/*
 * *
 *  * ObjectRiver Inc, http://www.objectriver.net/
 *  * Copyright (c) 2002-2013, ObjectRiver(tm). All rights reserved.
 *
 */

package com.objectriver.runtime.webrpc.xdr.marshals;

import com.objectriver.runtime.webrpc.exception.WebRpcMarshallingException;
import com.objectriver.runtime.webrpc.xdr.XDR;
import com.objectriver.runtime.webrpc.xdr.XdrProcT;
import com.objectriver.runtime.webrpc.xdr.XdrThing;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;

public class xdr_nullable extends XdrMarshal {
    private final XdrProcT procT;
    private final boolean isString;
    public xdr_nullable(XdrProcT procT) {
        this.procT = procT;
        this.isString = (procT == xdr_string.instance );
    }
    public boolean execute(XDR xdrs, XdrThing thing) throws WebRpcMarshallingException {
        try {
            if(isString) {
                return procT.execute(xdrs, thing);
            }
            else {
                return xdr_pointer(xdrs, thing, procT);
            }
        }
        catch (BufferUnderflowException ex) {
            throw new WebRpcMarshallingException("xdr_nullable", ex);
        }
        catch (BufferOverflowException ex) {
            throw new WebRpcMarshallingException("xdr_nullable", ex);
        }
    }
    public Class getClazz() {
        return procT.getClazz();
    }
}
