package com.objectriver.runtime.webrpc.xdr.marshals;

import com.objectriver.runtime.webrpc.exception.WebRpcMarshallingException;
import com.objectriver.runtime.webrpc.xdr.XDR;
import com.objectriver.runtime.webrpc.xdr.XdrThing;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;

/**
 * ObjectRiver Inc, http://www.objectriver.net/
 * Copyright (c) 2002-2013, ObjectRiver(tm). All rights reserved.
 */
public class xdr_short extends XdrMarshal {
    public static xdr_short instance;
    static {
        instance = new xdr_short();
    }
    private xdr_short() {}
    public boolean execute(XDR xdrs, XdrThing thing) throws WebRpcMarshallingException {
        try {
            if (xdrs.x_op == XDR.op.XDR_ENCODE) {
                Short shrt = (Short)thing.getThing();
                if(shrt==null) throw new WebRpcMarshallingException("xdr_short() short type can not be null! try defining as Short.");
                xdrs.put_int(shrt.intValue());
                return true;
            }
            if (xdrs.x_op == XDR.op.XDR_DECODE) {
                Integer integer = xdrs.get_int();
                thing.setThing(integer.shortValue());
                return true;
            }
        }
        catch (BufferUnderflowException ex) {
            throw new WebRpcMarshallingException("xdr_short", ex);
        }
        catch (BufferOverflowException ex) {
            throw new WebRpcMarshallingException("xdr_short", ex);
        }

       	if (xdrs.x_op == XDR.op.XDR_FREE) {
       		return (true);
        }
        return false;
    }
    public Class getClazz() {
        return Short.class;
    }
}
